<?php
/**
 * View Order Book Debug Logs
 * Access via: http://localhost/crispvort/backend/crispapi/view_orderbook_logs.php
 */

header("Content-Type: text/html; charset=UTF-8");

$logFile = __DIR__ . '/orderbook_debug.log';

if (!file_exists($logFile)) {
    echo "<h2>Order Book Debug Logs</h2>";
    echo "<p>Log file not found: $logFile</p>";
    echo "<p>Logs will be created when the orderbook API is called.</p>";
    exit;
}

$logs = file_get_contents($logFile);
$lines = explode("\n", $logs);
$recentLines = array_slice($lines, -100); // Last 100 lines

?>
<!DOCTYPE html>
<html>
<head>
    <title>Order Book Debug Logs</title>
    <style>
        body {
            font-family: monospace;
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 20px;
        }
        h2 {
            color: #4ec9b0;
        }
        .log-entry {
            padding: 5px;
            border-bottom: 1px solid #333;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        .log-entry:hover {
            background: #2d2d2d;
        }
        .timestamp {
            color: #808080;
        }
        .error {
            color: #f48771;
        }
        .success {
            color: #4ec9b0;
        }
        .info {
            color: #569cd6;
        }
        button {
            background: #007acc;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            margin: 10px 5px;
        }
        button:hover {
            background: #005a9e;
        }
    </style>
</head>
<body>
    <h2>Order Book Debug Logs</h2>
    <p>Showing last 100 log entries. Log file: <?php echo $logFile; ?></p>
    <button onclick="location.reload()">Refresh</button>
    <button onclick="window.location.href='?clear=1'">Clear Logs</button>
    <hr>
    
    <?php
    if (isset($_GET['clear'])) {
        file_put_contents($logFile, '');
        echo "<p style='color: #4ec9b0;'>Logs cleared!</p>";
        echo "<script>setTimeout(() => location.href='?', 1000);</script>";
        exit;
    }
    
    foreach (array_reverse($recentLines) as $line) {
        if (empty(trim($line))) continue;
        
        $class = 'info';
        if (stripos($line, 'error') !== false || stripos($line, 'failed') !== false) {
            $class = 'error';
        } elseif (stripos($line, 'success') !== false || stripos($line, 'completed') !== false) {
            $class = 'success';
        }
        
        echo "<div class='log-entry $class'>" . htmlspecialchars($line) . "</div>";
    }
    ?>
    
    <script>
        // Auto-refresh every 5 seconds
        setTimeout(() => location.reload(), 5000);
    </script>
</body>
</html>

