<?php
/**
 * Test endpoint for orderbook API
 * Use this to verify the API is accessible and working
 */

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$response = [
    "success" => true,
    "message" => "Orderbook API is accessible",
    "timestamp" => date("Y-m-d H:i:s"),
    "server" => [
        "php_version" => phpversion(),
        "method" => $_SERVER['REQUEST_METHOD'],
        "uri" => $_SERVER['REQUEST_URI'] ?? 'N/A'
    ],
    "request" => [
        "raw_input" => file_get_contents("php://input"),
        "get_params" => $_GET,
        "post_params" => $_POST
    ]
];

// Test database connection
$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    $response["database"] = [
        "connected" => false,
        "error" => $conn->connect_error
    ];
} else {
    $response["database"] = [
        "connected" => true,
        "server_info" => $conn->server_info
    ];
    
    // Check if orders table exists
    $tableCheck = $conn->query("SHOW TABLES LIKE 'orders'");
    if ($tableCheck && $tableCheck->num_rows > 0) {
        $response["database"]["orders_table"] = "exists";
        
        // Count orders
        $countResult = $conn->query("SELECT COUNT(*) as count FROM orders");
        if ($countResult) {
            $row = $countResult->fetch_assoc();
            $response["database"]["orders_count"] = intval($row['count']);
        }
    } else {
        $response["database"]["orders_table"] = "does_not_exist";
    }
    
    $conn->close();
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>

