<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Database connection
$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "error" => "Connection failed: " . $conn->connect_error]));
}

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data['username']) || !isset($data['email'])) {
    echo json_encode(["success" => false, "error" => "Username and email are required"]);
    $conn->close();
    exit;
}

$username = $conn->real_escape_string($data['username']);
$email = $conn->real_escape_string($data['email']);

// Verify user exists and email matches
$sql = "SELECT id, email FROM users WHERE username = '$username' AND email = '$email' LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "Invalid username or email"]);
    $conn->close();
    exit;
}

// Generate 6-digit verification code
$verification_code = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);

// Store code in database with expiration (10 minutes)
$expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));
$sql = "INSERT INTO pin_reset_codes (username, email, code, expires_at, created_at) 
        VALUES ('$username', '$email', '$verification_code', '$expires_at', NOW())
        ON DUPLICATE KEY UPDATE code = '$verification_code', expires_at = '$expires_at', created_at = NOW()";

if (!$conn->query($sql)) {
    echo json_encode(["success" => false, "error" => "Failed to generate reset code"]);
    $conn->close();
    exit;
}

// Send email with verification code
$subject = "PIN Reset Verification Code";
$message = "Your PIN reset verification code is: $verification_code\n\n";
$message .= "This code will expire in 10 minutes.\n\n";
$message .= "If you did not request this code, please ignore this email.";

$headers = "From: noreply@crispvort.com\r\n";
$headers .= "Reply-To: noreply@crispvort.com\r\n";
$headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

// Use PHP mail function (in production, use a proper email service like SendGrid, Mailgun, etc.)
$mail_sent = @mail($email, $subject, $message, $headers);

if ($mail_sent) {
    echo json_encode([
        "success" => true,
        "message" => "Verification code sent to your email",
        "code" => $verification_code // Remove this in production - only for testing
    ]);
} else {
    // Even if mail fails, we still return success for testing purposes
    // In production, you might want to handle this differently
    echo json_encode([
        "success" => true,
        "message" => "Verification code generated",
        "code" => $verification_code, // Remove this in production
        "warning" => "Email sending failed, but code is available for testing"
    ]);
}

$conn->close();
?>

