<?php
/**
 * OxaPay Webhook Handler
 * This endpoint receives deposit notifications from OxaPay
 */

header("Content-Type: application/json");

// Database connection
$servername = "localhost";
$username_db = "root";
$password = "";
$dbname = "vortex";

try {
    $db = new PDO("mysql:host=$servername;dbname=$dbname", $username_db, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/OxaPayService.php';

// Get webhook data
$webhookData = json_decode(file_get_contents("php://input"), true);

if (!$webhookData) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid webhook data']);
    exit;
}

// Log webhook for debugging
error_log("OxaPay Webhook received: " . json_encode($webhookData));

// Verify webhook (optional - if OxaPay provides signature verification)
$signature = $_SERVER['HTTP_X_OXAPAY_SIGNATURE'] ?? '';
$oxapayService = new OxaPayService(OXAPAY_MERCHANT_API_KEY, $db);

// Process the deposit
$result = $oxapayService->processDeposit($webhookData);

if ($result['success']) {
    http_response_code(200);
    echo json_encode([
        'status' => 'success',
        'message' => 'Deposit processed successfully'
    ]);
    
    // Log successful processing
    error_log("OxaPay Deposit Processed: " . json_encode($result));
} else {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $result['message'] ?? 'Failed to process deposit'
    ]);
    
    // Log error
    error_log("OxaPay Deposit Error: " . json_encode($result));
}

