<?php
/**
 * OxaPay API Connection Test Script
 * Use this to debug OxaPay API connection issues
 */

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/OxaPayService.php';

// Database connection
$servername = "localhost";
$username_db = "root";
$password = "";
$dbname = "vortex";

try {
    $db = new PDO("mysql:host=$servername;dbname=$dbname", $username_db, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// Get test parameters
$data = json_decode(file_get_contents("php://input"), true);
if (!$data) {
    $data = $_GET;
}

$testCoin = $data['coin'] ?? 'BTC';
$testUsername = $data['username'] ?? 'testuser';

$oxapayService = new OxaPayService(OXAPAY_MERCHANT_API_KEY, $db);

// Test 1: Direct API call to see raw response
$testUrl = 'https://api.oxapay.com/v1/payment/static-address';
$testData = [
    'network' => 'Bitcoin',
    'currency' => 'BTC', // Use 'currency' not 'to_currency'
    'callback_url' => 'https://newapp.coinvortex.live/backend/crispapi/oxapay/webhook.php',
    'order_id' => 'test_' . time(),
    'description' => 'Test address creation'
];

$ch = curl_init($testUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($testData),
    CURLOPT_HTTPHEADER => [
        'merchant_api_key: ' . OXAPAY_MERCHANT_API_KEY,
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

$responseData = json_decode($response, true);

echo json_encode([
    'test' => 'OxaPay API Connection Test',
    'api_key_set' => !empty(OXAPAY_MERCHANT_API_KEY),
    'api_key_length' => strlen(OXAPAY_MERCHANT_API_KEY),
    'api_key_preview' => substr(OXAPAY_MERCHANT_API_KEY, 0, 10) . '...',
    'request_url' => $testUrl,
    'request_data' => $testData,
    'http_code' => $httpCode,
    'curl_error' => $curlError ?: 'None',
    'raw_response' => $response,
    'parsed_response' => $responseData,
    'json_error' => json_last_error() !== JSON_ERROR_NONE ? json_last_error_msg() : 'None'
], JSON_PRETTY_PRINT);

