<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    exit;
}

// Database connection
$servername = "localhost";
$username_db = "root";
$password = "";
$dbname = "vortex";

try {
    $db = new PDO("mysql:host=$servername;dbname=$dbname", $username_db, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

// Get request data
$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    $data = $_POST;
}

$username = $data['username'] ?? '';
$coin = $data['coin'] ?? '';
$cointicker = $data['cointicker'] ?? $coin;

if (empty($username) || empty($cointicker)) {
    echo json_encode(['success' => false, 'message' => 'Username and coin are required']);
    exit;
}

// Check if coin is Solana - skip OxaPay for Solana
if (strtoupper($cointicker) === 'SOL') {
    // For Solana, use existing Solana address generation
    // You can redirect to your existing Solana address creation endpoint
    echo json_encode([
        'success' => false, 
        'message' => 'Solana deposits use native Solana addresses. Use the Solana address endpoint instead.'
    ]);
    exit;
}

// Load OxaPay configuration
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/OxaPayService.php';

// Initialize OxaPay service
$oxapayService = new OxaPayService(OXAPAY_MERCHANT_API_KEY, $db);

// Map coin ticker to network
$networkMap = [
    'BTC' => 'Bitcoin',
    'ETH' => 'Ethereum',
    'LTC' => 'Litecoin',
    'BNB' => 'BinanceSmartChain',
    'TRX' => 'Tron',
    'XRP' => 'Ripple',
    'DOGE' => 'Dogecoin',
    'USDT' => 'Tether',
    'USDC' => 'USDCoin',
    'BUSD' => 'BinanceUSD',
    'ADA' => 'Cardano',
    'DOT' => 'Polkadot',
    'MATIC' => 'Polygon',
    'AVAX' => 'Avalanche'
];

$network = $networkMap[strtoupper($cointicker)] ?? strtoupper($cointicker);

// Create static address
$result = $oxapayService->createStaticAddress($username, strtoupper($cointicker), $network);

if ($result['success']) {
    // Record in payments table
    $txid = "New Address";
    $mstatus = "Pending";
    $coinvalue = 0.00;
    $status = 0;
    $address = $result['address'];
    $currency = strtoupper($cointicker);

    try {
        $stmt = $db->prepare("
            INSERT INTO payments (username, txid, status, value, fin, address, coin, payment_id)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $username,
            $txid,
            $mstatus,
            $coinvalue,
            $status,
            $address,
            $currency,
            $result['order_id'] ?? ''
        ]);

        // Update user's address field if column exists
        $coinColumn = strtolower($currency) . 'oxapay_address';
        try {
            $updateStmt = $db->prepare("UPDATE users SET {$coinColumn} = ? WHERE username = ?");
            $updateStmt->execute([$address, $username]);
        } catch (PDOException $e) {
            // Column doesn't exist, that's okay
        }

        echo json_encode([
            'success' => true,
            'token' => $address,
            'address' => $address,
            'message' => $result['is_new'] ? 'New address successfully created.' : 'Address retrieved successfully.',
            'is_new' => $result['is_new']
        ]);
    } catch (PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage()
        ]);
    }
} else {
    // Return detailed error information
    $errorMessage = $result['message'] ?? 'Failed to create address';
    
    // Log the full error for debugging
    error_log("OxaPay Address Creation Error: " . json_encode($result));
    
    echo json_encode([
        'success' => false,
        'message' => $errorMessage,
        'debug' => isset($result['debug']) ? $result['debug'] : null,
        'http_code' => isset($result['http_code']) ? $result['http_code'] : null
    ]);
}

