<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'vendor/autoload.php';
use Slim\Factory\AppFactory;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use GuzzleHttp\Client;

$app = AppFactory::create();
$db = new PDO("mysql:host=localhost;dbname=payment_processor", "root", ""); // Update credentials
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// CORS Middleware
$app->add(function (Request $request, $handler) {
    $response = $handler->handle($request);
    return $response
        ->withHeader('Access-Control-Allow-Origin', 'http://localhost:5173')
        ->withHeader('Access-Control-Allow-Headers', 'Content-Type, Authorization')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS');
});

// Handle OPTIONS preflight requests
$app->options('/{routes:.+}', function (Request $request, Response $response) {
    return $response;
});

$app->post('/create-address', function (Request $request, Response $response) use ($db) {
    try {
        $data = json_decode($request->getBody()->getContents(), true);
        $username = $data['username'] ?? '';
        if (empty($username)) throw new Exception("Username is required");

        $stmt = $db->prepare("SELECT wallet_address FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetchColumn()) throw new Exception("Username already exists");

        $client = new Client();
        $res = $client->post('http://localhost:3001/generate-address');
        $result = json_decode($res->getBody()->getContents(), true);

        $stmt = $db->prepare("INSERT INTO users (username, wallet_address, private_key) VALUES (?, ?, ?)");
        $stmt->execute([$username, $result['address'], $result['privateKey']]);

        $response->getBody()->write(json_encode(['address' => $result['address']]));
    } catch (Exception $e) {
        $response = $response->withStatus(400);
        $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
    }
    return $response->withHeader('Content-Type', 'application/json');
});

$app->post('/record-deposit', function (Request $request, Response $response) use ($db) {
    try {
        $data = json_decode($request->getBody()->getContents(), true);
        error_log("Received payload: " . print_r($data, true));

        $username = $data['username'] ?? '';
        $amount = $data['amount'] ?? 0;
        $tokenMint = $data['tokenMint'] ?? null;
        $signature = $data['signature'] ?? '';
        if (empty($username) || $amount <= 0 || empty($signature)) {
            throw new Exception("Missing required fields: username=$username, amount=$amount, signature=$signature");
        }

        $stmt = $db->prepare("SELECT id, wallet_address FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$user) throw new Exception("User not found: $username");

        $tokenName = $tokenMint ? ($tokenMint === 'EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v' ? 'USDC' : 'Unknown') : 'SOL';

        $stmt = $db->prepare(
            "INSERT INTO deposits (user_id, wallet_address, amount, token_mint, token_name, timestamp, signature) 
            VALUES (?, ?, ?, ?, ?, NOW(), ?)"
        );
        $stmt->execute([$user['id'], $user['wallet_address'], $amount, $tokenMint, $tokenName, $signature]);

        $response->getBody()->write(json_encode(['status' => 'Deposit recorded']));
    } catch (Exception $e) {
        error_log("Error in /record-deposit: " . $e->getMessage());
        $response = $response->withStatus(400);
        $response->getBody()->write(json_encode(['error' => $e->getMessage()]));
    }
    return $response->withHeader('Content-Type', 'application/json');
});

$app->get('/deposits', function (Request $request, Response $response) use ($db) {
    $username = $request->getQueryParams()['username'] ?? ''; // Fixed typo 'username vahid'
    $stmt = $db->prepare("SELECT d.* FROM deposits d JOIN users u ON d.user_id = u.id WHERE u.username = ?");
    $stmt->execute([$username]);
    $deposits = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $response->getBody()->write(json_encode($deposits));
    return $response->withHeader('Content-Type', 'application/json');
});

$app->run();