<?php
require_once __DIR__ . '/../config/database.php';
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $username = $input['username'];
    $password = password_hash($input['password'], PASSWORD_DEFAULT);

    $stmt = $pdo->prepare("INSERT INTO users (username, password, rating, balance) VALUES (?, ?, 5, 0)");
    $stmt->execute([$username, $password]);

    echo json_encode(['success' => true]);
} elseif ($method === 'GET') {
    $userId = $_GET['id'];
    $stmt = $pdo->prepare("SELECT id, username, rating, balance FROM users WHERE id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode($user);
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}
