<?php
require_once __DIR__ . '/../config/database.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $listingId = $input['listingId'];
    $buyerId = $input['buyerId'];

    // Fetch listing and seller info
    $stmt = $pdo->prepare("SELECT * FROM listings WHERE id = ?");
    $stmt->execute([$listingId]);
    $listing = $stmt->fetch(PDO::FETCH_ASSOC);

    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$listing['seller_id']]);
    $seller = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($seller['balance'] < $listing['amount']) {
        http_response_code(400);
        echo json_encode(['error' => 'Seller has insufficient balance']);
        exit;
    }

    // Deduct balance from seller
    $pdo->prepare("UPDATE users SET balance = balance - ? WHERE id = ?")
        ->execute([$listing['amount'], $seller['id']]);

    // Create trade record
    $pdo->prepare("
        INSERT INTO trades (listing_id, buyer_id, amount, total_price, status)
        VALUES (?, ?, ?, ?, 'active')
    ")->execute([
        $listingId,
        $buyerId,
        $listing['amount'],
        $listing['amount'] * $listing['price_per_unit']
    ]);

    echo json_encode(['success' => true, 'message' => 'Trade initiated']);
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}
