-- Seed data for order books
-- This populates the order book with buy and sell orders for different trading pairs

-- Note: This assumes you have users in the database. Adjust user_id values as needed.
-- You may need to run: SELECT id, username FROM users LIMIT 10; to get valid user IDs

-- Clear existing orders (optional - comment out if you want to keep existing data)
-- DELETE FROM orders WHERE id > 0;

-- BTC/USDT Orders
-- Buy orders (bids) - users want to buy BTC with USDT
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(1, 'user1', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 49000.00, 0.05, 0.05, 2450.00, 'pending'),
(1, 'user1', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48950.00, 0.10, 0.10, 4895.00, 'pending'),
(2, 'user2', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48900.00, 0.15, 0.15, 7335.00, 'pending'),
(2, 'user2', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48850.00, 0.20, 0.20, 9770.00, 'pending'),
(3, 'user3', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48800.00, 0.25, 0.25, 12200.00, 'pending'),
(3, 'user3', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48750.00, 0.30, 0.30, 14625.00, 'pending'),
(1, 'user1', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48700.00, 0.08, 0.08, 3896.00, 'pending'),
(2, 'user2', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48650.00, 0.12, 0.12, 5838.00, 'pending'),
(3, 'user3', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48600.00, 0.18, 0.18, 8748.00, 'pending'),
(1, 'user1', 'BTC/USDT', 'BTC', 'USDT', 'buy', 'limit', 48550.00, 0.22, 0.22, 10681.00, 'pending');

-- Sell orders (asks) - users want to sell BTC for USDT
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(4, 'user4', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49200.00, 0.05, 0.05, 2460.00, 'pending'),
(4, 'user4', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49250.00, 0.10, 0.10, 4925.00, 'pending'),
(5, 'user5', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49300.00, 0.15, 0.15, 7395.00, 'pending'),
(5, 'user5', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49350.00, 0.20, 0.20, 9870.00, 'pending'),
(6, 'user6', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49400.00, 0.25, 0.25, 12350.00, 'pending'),
(6, 'user6', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49450.00, 0.30, 0.30, 14835.00, 'pending'),
(4, 'user4', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49500.00, 0.08, 0.08, 3960.00, 'pending'),
(5, 'user5', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49550.00, 0.12, 0.12, 5946.00, 'pending'),
(6, 'user6', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49600.00, 0.18, 0.18, 8928.00, 'pending'),
(4, 'user4', 'BTC/USDT', 'BTC', 'USDT', 'sell', 'limit', 49650.00, 0.22, 0.22, 10923.00, 'pending');

-- ETH/USDT Orders
-- Buy orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(1, 'user1', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2580.00, 1.5, 1.5, 3870.00, 'pending'),
(2, 'user2', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2575.00, 2.0, 2.0, 5150.00, 'pending'),
(3, 'user3', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2570.00, 2.5, 2.5, 6425.00, 'pending'),
(1, 'user1', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2565.00, 3.0, 3.0, 7695.00, 'pending'),
(2, 'user2', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2560.00, 1.8, 1.8, 4608.00, 'pending'),
(3, 'user3', 'ETH/USDT', 'ETH', 'USDT', 'buy', 'limit', 2555.00, 2.2, 2.2, 5621.00, 'pending');

-- Sell orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(4, 'user4', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2595.00, 1.5, 1.5, 3892.50, 'pending'),
(5, 'user5', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2600.00, 2.0, 2.0, 5200.00, 'pending'),
(6, 'user6', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2605.00, 2.5, 2.5, 6512.50, 'pending'),
(4, 'user4', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2610.00, 3.0, 3.0, 7830.00, 'pending'),
(5, 'user5', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2615.00, 1.8, 1.8, 4707.00, 'pending'),
(6, 'user6', 'ETH/USDT', 'ETH', 'USDT', 'sell', 'limit', 2620.00, 2.2, 2.2, 5764.00, 'pending');

-- SOL/USDT Orders
-- Buy orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(1, 'user1', 'SOL/USDT', 'SOL', 'USDT', 'buy', 'limit', 142.00, 10.0, 10.0, 1420.00, 'pending'),
(2, 'user2', 'SOL/USDT', 'SOL', 'USDT', 'buy', 'limit', 141.50, 15.0, 15.0, 2122.50, 'pending'),
(3, 'user3', 'SOL/USDT', 'SOL', 'USDT', 'buy', 'limit', 141.00, 20.0, 20.0, 2820.00, 'pending'),
(1, 'user1', 'SOL/USDT', 'SOL', 'USDT', 'buy', 'limit', 140.50, 25.0, 25.0, 3512.50, 'pending'),
(2, 'user2', 'SOL/USDT', 'SOL', 'USDT', 'buy', 'limit', 140.00, 30.0, 30.0, 4200.00, 'pending');

-- Sell orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(4, 'user4', 'SOL/USDT', 'SOL', 'USDT', 'sell', 'limit', 142.50, 10.0, 10.0, 1425.00, 'pending'),
(5, 'user5', 'SOL/USDT', 'SOL', 'USDT', 'sell', 'limit', 143.00, 15.0, 15.0, 2145.00, 'pending'),
(6, 'user6', 'SOL/USDT', 'SOL', 'USDT', 'sell', 'limit', 143.50, 20.0, 20.0, 2870.00, 'pending'),
(4, 'user4', 'SOL/USDT', 'SOL', 'USDT', 'sell', 'limit', 144.00, 25.0, 25.0, 3600.00, 'pending'),
(5, 'user5', 'SOL/USDT', 'SOL', 'USDT', 'sell', 'limit', 144.50, 30.0, 30.0, 4335.00, 'pending');

-- BNB/USDT Orders
-- Buy orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(1, 'user1', 'BNB/USDT', 'BNB', 'USDT', 'buy', 'limit', 315.00, 5.0, 5.0, 1575.00, 'pending'),
(2, 'user2', 'BNB/USDT', 'BNB', 'USDT', 'buy', 'limit', 314.50, 7.5, 7.5, 2358.75, 'pending'),
(3, 'user3', 'BNB/USDT', 'BNB', 'USDT', 'buy', 'limit', 314.00, 10.0, 10.0, 3140.00, 'pending'),
(1, 'user1', 'BNB/USDT', 'BNB', 'USDT', 'buy', 'limit', 313.50, 12.5, 12.5, 3918.75, 'pending');

-- Sell orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(4, 'user4', 'BNB/USDT', 'BNB', 'USDT', 'sell', 'limit', 316.50, 5.0, 5.0, 1582.50, 'pending'),
(5, 'user5', 'BNB/USDT', 'BNB', 'USDT', 'sell', 'limit', 317.00, 7.5, 7.5, 2377.50, 'pending'),
(6, 'user6', 'BNB/USDT', 'BNB', 'USDT', 'sell', 'limit', 317.50, 10.0, 10.0, 3175.00, 'pending'),
(4, 'user4', 'BNB/USDT', 'BNB', 'USDT', 'sell', 'limit', 318.00, 12.5, 12.5, 3975.00, 'pending');

-- ADA/USDT Orders
-- Buy orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(1, 'user1', 'ADA/USDT', 'ADA', 'USDT', 'buy', 'limit', 0.48, 1000.0, 1000.0, 480.00, 'pending'),
(2, 'user2', 'ADA/USDT', 'ADA', 'USDT', 'buy', 'limit', 0.479, 1500.0, 1500.0, 718.50, 'pending'),
(3, 'user3', 'ADA/USDT', 'ADA', 'USDT', 'buy', 'limit', 0.478, 2000.0, 2000.0, 956.00, 'pending'),
(1, 'user1', 'ADA/USDT', 'ADA', 'USDT', 'buy', 'limit', 0.477, 2500.0, 2500.0, 1192.50, 'pending');

-- Sell orders
INSERT INTO `orders` (`user_id`, `username`, `pair`, `base_coin`, `quote_coin`, `order_type`, `order_side`, `price`, `amount`, `remaining_amount`, `total`, `status`) VALUES
(4, 'user4', 'ADA/USDT', 'ADA', 'USDT', 'sell', 'limit', 0.481, 1000.0, 1000.0, 481.00, 'pending'),
(5, 'user5', 'ADA/USDT', 'ADA', 'USDT', 'sell', 'limit', 0.482, 1500.0, 1500.0, 723.00, 'pending'),
(6, 'user6', 'ADA/USDT', 'ADA', 'USDT', 'sell', 'limit', 0.483, 2000.0, 2000.0, 966.00, 'pending'),
(4, 'user4', 'ADA/USDT', 'ADA', 'USDT', 'sell', 'limit', 0.484, 2500.0, 2500.0, 1210.00, 'pending');

