<?php
require_once __DIR__ . '/../config/database.php';

$method = $_SERVER['REQUEST_METHOD'];
$id = $_GET['id'];

if ($method === 'GET') {
    $stmt = $pdo->prepare("
        SELECT l.*, u.username, u.rating
        FROM listings l
        JOIN users u ON l.seller_id = u.id
        WHERE l.id = :id
        ORDER BY l.id DESC
    ");
    $stmt->execute(['id' => $id]);
    $listings = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $formatted = array_map(function ($row) {
        return [
            'id' => $row['id'],
            'amount' => $row['amount'],
            'price_per_unit' => $row['price_per_unit'],
            'payment_method' => $row['payment_method'],
            'currency' => $row['currency'],
            'min' => $row['min_limit'],
            'max' => $row['max_limit'],
            'coin' => $row['coin'],
            'accepted_currency' => $row['accepted_currency'], // corrected key
            'seller' => [
                'username' => $row['username'],
                'rating' => $row['rating'],
                'ownerid' => $row['seller_id']
            ]
        ];
    }, $listings);

    // Optional: Output the result
    header('Content-Type: application/json');
    // echo json_encode($formatted);


    echo json_encode($formatted);

} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $stmt = $pdo->prepare("
        INSERT INTO listings (seller_id, amount, price_per_unit, payment_method, currency)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([
        $input['sellerId'],
        $input['amount'],
        $input['price_per_unit'],
        $input['payment_method'],
        $input['currency']
    ]);

    echo json_encode(['success' => true, 'message' => 'Listing created']);
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
}
