<?php
// require '../config.php';
require_once __DIR__ . '/../config/database.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);
$user_iddd = isset($input['user_id']) ? intval($input['user_id']) : 0;
$user_id = $input['user_id'];
// $user_id = $_GET['user_id'];
if (!$user_id) {
    echo json_encode(['error' => 'Missing user_id']);
    exit;
}

try {
    // Get user basic profile
    $stmt = $pdo->prepare("SELECT id, username, publicname, country, created_at, avatar FROM users WHERE id = :user_id LIMIT 1");
    $stmt->execute(['user_id' => $user_id]);
    $profile = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$profile) {
        echo json_encode(['error' => 'User not found']);
        exit;
    }

    // Optionally attach stats (can also be done via get_user_stats.php)
    $stmtTotal = $pdo->prepare("SELECT COUNT(*) FROM trades WHERE buyer_id = :user_id OR seller_id = :user_id");
    $stmtTotal->execute(['user_id' => $user_id]);
    $profile['total_trades'] = (int) $stmtTotal->fetchColumn();

    $stmtCompleted = $pdo->prepare("SELECT COUNT(*) FROM trades WHERE (buyer_id = :user_id OR seller_id = :user_id) AND status = 'completed'");
    $stmtCompleted->execute(['user_id' => $user_id]);
    $profile['completed_trades'] = (int) $stmtCompleted->fetchColumn();

    $stmtRating = $pdo->prepare("SELECT AVG(score) FROM ratings WHERE user_id = :user_id");
    $stmtRating->execute(['user_id' => $user_id]);
    $profile['avg_rating'] = round(floatval($stmtRating->fetchColumn()), 2);

    $profile['success_rate'] = $profile['total_trades'] > 0 
        ? round(($profile['completed_trades'] / $profile['total_trades']) * 100, 2)
        : 0;

    echo json_encode($profile);

} catch (Exception $e) {
    echo json_encode(['error' => 'DB error: ' . $e->getMessage()]);
}
