<?php
// get_trade.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

require_once __DIR__ . '/../config/database.php';

try {
    $tradeId = $_GET['trade_id'] ?? $_GET['tradeId'] ?? 0;
    $userId = $_GET['user_id'] ?? null; // Optional: current user ID to check if they've rated
    
    if (!$tradeId) {
        http_response_code(400);
        echo json_encode(['error' => 'Trade ID is required']);
        exit;
    }
    
    // Get trade with listing and user information
    $stmt = $pdo->prepare("
        SELECT 
            t.*,
            l.coin,
            l.price_per_unit,
            l.payment_method,
            l.currency as listing_currency,
            l.accepted_currency,
            buyer.username as buyer_username,
            seller.username as seller_username,
            admin.username as admin_username
        FROM trades t
        JOIN listings l ON t.listing_id = l.id
        LEFT JOIN users buyer ON t.buyer_id = buyer.id
        LEFT JOIN users seller ON t.seller_id = seller.id
        LEFT JOIN users admin ON t.admin_id = admin.id
        WHERE t.id = ?
    ");
    $stmt->execute([$tradeId]);
    $trade = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($trade) {
        // Get chat messages
        $msgStmt = $pdo->prepare("SELECT * FROM chat WHERE trade_id = ? ORDER BY created_at ASC");
        $msgStmt->execute([$tradeId]);
        $trade['messages'] = $msgStmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Check if current user has rated this trade
        if ($userId) {
            $ratingStmt = $pdo->prepare("SELECT rating, comment FROM ratings WHERE trade_id = ? AND rater_id = ?");
            $ratingStmt->execute([$tradeId, $userId]);
            $userRating = $ratingStmt->fetch();
            
            if ($userRating) {
                $trade['has_rating'] = true;
                $trade['current_rating'] = (int)$userRating['rating'];
                $trade['current_comment'] = $userRating['comment'] ?? null;
            } else {
                $trade['has_rating'] = false;
                $trade['current_rating'] = null;
                $trade['current_comment'] = null;
            }
        } else {
            $trade['has_rating'] = false;
            $trade['current_rating'] = null;
            $trade['current_comment'] = null;
        }
        
        // Ensure currency field exists
        if (!isset($trade['currency'])) {
            $trade['currency'] = $trade['listing_currency'] ?? $trade['accepted_currency'] ?? 'USD';
        }
        
        echo json_encode($trade);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Trade not found']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>