<?php
require_once __DIR__ . '/../config/database.php';

$input = json_decode(file_get_contents('php://input'), true);
$tradeId = $input['tradeId'];
$sellerId = $input['sellerId'];

// Verify seller owns this trade/listing
$stmt = $pdo->prepare("
    SELECT t.*, l.seller_id 
    FROM trades t
    JOIN listings l ON t.listing_id = l.id
    WHERE t.id = ? AND l.seller_id = ?
");
$stmt->execute([$tradeId, $sellerId]);
$trade = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$trade) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized or trade not found']);
    exit;
}

// Release to buyer
$pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?")
    ->execute([$trade['amount'], $trade['buyer_id']]);

// Mark trade as completed
$pdo->prepare("UPDATE trades SET status = 'completed' WHERE id = ?")
    ->execute([$tradeId]);

echo json_encode(['success' => true, 'message' => 'Funds released to buyer']);
