<?php
// Enable error display for development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Allow CORS (optional for local testing)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Path to your debug log file
$logFile = 'debug_listing.log';

// Log helper
function log_entry($message) {
    global $logFile;
    file_put_contents($logFile, date("Y-m-d H:i:s") . " - " . $message . PHP_EOL, FILE_APPEND);
}

// Log raw input
$rawInput = file_get_contents("php://input");
log_entry("RAW INPUT: $rawInput");

// Decode JSON input
$data = json_decode($rawInput, true);
log_entry("DECODED: " . json_encode($data));

// Check for required fields
$requiredFields = ['sellerId', 'coin', 'amount', 'price'];

foreach ($requiredFields as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        $error = "Missing required field: $field";
        log_entry("ERROR: $error");
        echo json_encode(['success' => false, 'message' => $error]);
        exit;
    }
}


// sellerId: 1,
//         amount,
//         price_per_unit: price,
//         price:price,
//         payment_method: paymentMethod,
//         currency,
//         coin,
//         country,
//         trade_type,
//         min,
//         max,
//         accepted,
//         username:userData.username,
//         publicname:userData.publicname
// Extract data
$seller_id = (int)$data['sellerId'];
$crypto = $data['coin'];
$amount = (float)$data['amount'];
$price = (float)$data['price'];
$min = (float)$data['min'];
$max = (float)$data['max'];
$trade_type = $data['trade_type'];
$accepted = $data['accepted'];
$pay_method = $data['payment_method'];
$username = $data['username'];

// Connect to DB
$host = "localhost";
$dbname = "vortex";
$username = "root";
$password = "";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    log_entry("DB connection successful");
} catch (PDOException $e) {
    log_entry("DB ERROR: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection error']);
    exit;
}

// Insert listing
try {
    $stmt = $pdo->prepare("INSERT INTO listings (seller_id, coin, amount, min_limit, max_limit, price_per_unit, trade_type, payment_method, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'active', NOW())");
    $stmt->execute([$seller_id, $crypto, $amount, $min, $max, $price, $trade_type, $pay_method]);
    $listingId = $pdo->lastInsertId();
    log_entry("Listing created: ID $listingId");

    echo json_encode(['success' => true, 'listing_id' => $listingId]);
} catch (PDOException $e) {
    log_entry("INSERT ERROR: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to create listing']);
}
?>
