<?php
/**
 * Check if order book tables exist
 */

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$servername = "localhost";
$username = "coinfzbe_pro_user";
$password = "_xS89yo#g?Rv";
$dbname = "coinfzbe_vortexprp";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode([
        "error" => "Connection failed: " . $conn->connect_error,
        "tables_exist" => false
    ]);
    exit;
}

// Check if tables exist
$ordersExists = $conn->query("SHOW TABLES LIKE 'orders'");
$exchangeTradesExists = $conn->query("SHOW TABLES LIKE 'exchange_trades'");

$result = [
    "orders_table_exists" => $ordersExists && $ordersExists->num_rows > 0,
    "exchange_trades_table_exists" => $exchangeTradesExists && $exchangeTradesExists->num_rows > 0,
    "all_tables_exist" => false
];

if ($result["orders_table_exists"] && $result["exchange_trades_table_exists"]) {
    $result["all_tables_exist"] = true;
    
    // Get table info
    $ordersCount = $conn->query("SELECT COUNT(*) as count FROM orders");
    if ($ordersCount) {
        $row = $ordersCount->fetch_assoc();
        $result["orders_count"] = intval($row['count']);
    }
    
    $tradesCount = $conn->query("SELECT COUNT(*) as count FROM exchange_trades");
    if ($tradesCount) {
        $row = $tradesCount->fetch_assoc();
        $result["trades_count"] = intval($row['count']);
    }
}

$conn->close();

echo json_encode($result);
?>

